#include "SlotMachine.h"

SlotMachine::SlotMachine()
{
}


SlotMachine::~SlotMachine()
{
}

bool SlotMachine::loadMTL(char* modelFilename, char* mtlFilename, int renderingShape)
{
	Model::loadMTL(modelFilename, mtlFilename, renderingShape);	//Machine
	_SlotWheels[0].loadMTL("Assets/Models/slotWheel.obj", "Assets/Models/slotWheel.mtl");	//
	_SlotWheels[1].loadMTL("Assets/Models/slotWheel.obj", "Assets/Models/slotWheel.mtl");	//	Spinners
	_SlotWheels[2].loadMTL("Assets/Models/slotWheel.obj", "Assets/Models/slotWheel.mtl");	//
	texture = loadTextureRet("Assets/Textures/slotLight.png");
	return true;
}

void SlotMachine::SetLights(SpotLight* winLight)
{
	_GreenWinLight = winLight;
}

void SlotMachine::Update(float dt)
{
	if (_CurrentlyActivated && !_DoneRotating)	//If the machine is activated and the spinners aren't done
	{
		_Rotation += 45.0f * dt;	//Increment rotation
	}

	else if (_CurrentlyActivated && _DoneRotating)	//If the machine is activated and the spinners are done
	{
		if (!_FlashingWin)	//If the win light isn't flashing
		{
			glEnable(_GreenWinLight->GetID());	//Enable the light
			_GreenWinLight->Flash(1.0f, 5.0f, dt);	//Flash it
			_FlashingWin = true;
		}

		else
		{
			if (!_GreenWinLight->CurrentlyFlashing)	//If the flashing has stopped
			{
				glDisable(_GreenWinLight->GetID());	//Disable the light

				//Reset values
				_FlashingWin = false;
				_DoneRotating = false;
				_CurrentlyActivated = false;
			}
		}
	}
}

void SlotMachine::render(Vector3 position)
{
	glPushMatrix();
		glDisable(_GreenWinLight->GetID());	//Disable light so model unaffected
		glTranslatef(position.x, position.y, position.z);
		glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
		Model::render();	//Machine

		glPushMatrix();	//Spinners
			glRotatef(30.0f, 1.0f, 0.0f, 0.0f);
			glTranslatef(0.0f, 0.0f, -0.1f);
			glScalef(1.0f, 0.8f, 0.8f);

			glPushMatrix();
				glTranslatef(-0.28f, 0.0f, 0.0f);

				if (_Rotation <= 360.f * 4.0f)	//Rotate spinner 1 4 times
				{
					glRotatef(_Rotation, 1.0f, 0.0f, 0.0f);	
				}

				_SlotWheels[0].render();
			glPopMatrix();

			glPushMatrix();

				if (_Rotation <= 360.f * 5.0f)	//Rotate spinner 2 5 times
				{
					glRotatef(_Rotation, 1.0f, 0.0f, 0.0f);
				}

				_SlotWheels[1].render();
			glPopMatrix();

			glPushMatrix();
				glTranslatef(0.28f, 0.0f, 0.0f);

				if (_Rotation <= 360.f * 6.0f)	//Rotate spiiner 3 6 times
				{
					glRotatef(_Rotation, 1.0f, 0.0f, 0.0f);
				}

				else
				{
					_DoneRotating = true;
					_Rotation = 0.0f;
				}

				_SlotWheels[2].render();
			glPopMatrix();
		glPopMatrix();

		if (_GreenWinLight->CurrentlyFlashing)	//If we should flash, enable the light
		{
			glEnable(_GreenWinLight->GetID());
		}

		//Draw "cheat" quad, slightly ahead of model
		glBindTexture(GL_TEXTURE_2D, texture);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);

		glBegin(GL_QUADS);
			glNormal3f(0.0f, 0.0f, 1.0f);
			glTexCoord2f(0.0f, 0.0f);
			glVertex3f(-0.50f, 1.11f, 0.23f);
			glNormal3f(0.0f, 0.0f, 1.0f);
			glTexCoord2f(0.0f, 1.0f);
			glVertex3f(-0.50f, 0.67f, 0.23f);
			glNormal3f(0.0f, 0.0f, 1.0f);
			glTexCoord2f(1.0f, 1.0f);
			glVertex3f(0.50f, 0.67f, 0.23f);
			glNormal3f(0.0f, 0.0f, 1.0f);
			glTexCoord2f(1.0f, 0.0f);
			glVertex3f(0.50f, 1.11f, 0.23f);
		glEnd();

	glPopMatrix();	
}

void SlotMachine::Activate()
{
	_CurrentlyActivated = true;
}